<?php
/**
 * Run once to create admin user: php scripts/create-admin.php
 * From backend dir: php scripts/create-admin.php [email] [password]
 */
require __DIR__ . '/../vendor/autoload.php';
if (file_exists(__DIR__ . '/../.env')) {
    $dotenv = Dotenv\Dotenv::createImmutable(__DIR__ . '/..');
    $dotenv->load();
}

$dsn = sprintf(
    'mysql:host=%s;dbname=%s;charset=utf8mb4',
    $_ENV['DB_HOST'] ?? '127.0.0.1',
    $_ENV['DB_NAME'] ?? 'bonza'
);
try {
    $pdo = new PDO($dsn, $_ENV['DB_USER'] ?? 'root', $_ENV['DB_PASS'] ?? '', [
        PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
        PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
    ]);
} catch (PDOException $e) {
    fwrite(STDERR, "DB connection failed: " . $e->getMessage() . "\n");
    fwrite(STDERR, "Create database and run schema: mysql -u root -p -e 'CREATE DATABASE bonza;' && mysql -u root -p bonza < schema.sql\n");
    exit(1);
}

$adminEmail = $argv[1] ?? 'admin@bonza.com';
$adminPassword = $argv[2] ?? 'admin123';

$stmt = $pdo->prepare('SELECT id FROM users WHERE email = ?');
$stmt->execute([$adminEmail]);
if ($stmt->fetch()) {
    echo "Admin already exists: $adminEmail\n";
    exit(0);
}

$pdo->prepare('INSERT INTO users (email, password, name, number, role, status, referral_id, wallet_balance) VALUES (?, ?, ?, ?, ?, ?, ?, ?)')->execute([
    $adminEmail,
    password_hash($adminPassword, PASSWORD_DEFAULT),
    'Admin',
    '0000000000',
    'admin',
    'approved',
    'AD0000',
    0,
]);

echo "Admin created: $adminEmail / $adminPassword\n";

$stmt = $pdo->prepare('SELECT id FROM users WHERE referral_id = ?');
$stmt->execute(['FO0000']);
if (!$stmt->fetch()) {
    $pdo->prepare('INSERT INTO users (email, password, name, number, role, status, referral_id, referred_by, wallet_balance) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)')->execute([
        'founder@bonza.com',
        password_hash('founder', PASSWORD_DEFAULT),
        'Founder',
        '0000000001',
        'user',
        'approved',
        'FO0000',
        null,
        0,
    ]);
    echo "Founder user created. Use referral code FO0000 for first MLM registration.\n";
}
