<?php
require __DIR__ . '/../../../bootstrap.php';

$user = requireAuth();
$stmt = db()->prepare('SELECT wallet_balance FROM users WHERE id = ?');
$stmt->execute([$user['_id']]);
$u = $stmt->fetch();
if (($user['kycStatus'] ?? '') !== 'approved') {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'KYC must be approved to withdraw']);
    return;
}

$stmt = db()->query('SELECT min_withdraw_balance FROM settings WHERE id = 1');
$settings = $stmt->fetch();
$minBalance = (float) ($settings['min_withdraw_balance'] ?? 0);
$balance = (float) ($u['wallet_balance'] ?? 0);
if ($balance < $minBalance) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => "Minimum balance to maintain: $minBalance. Cannot withdraw below this."]);
    return;
}

$input = getJsonInput();
$amount = (float) ($input['amount'] ?? 0);
if ($amount <= 0 || $amount > ($balance - $minBalance)) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'Invalid amount or exceeds withdrawable balance']);
    return;
}

$newBalance = $balance - $amount;
$pdo = db();
$pdo->prepare('UPDATE users SET wallet_balance = ? WHERE id = ?')->execute([$newBalance, $user['_id']]);
$pdo->prepare('INSERT INTO wallet_transactions (user_id, type, amount, balance_after, description, status) VALUES (?, ?, ?, ?, ?, ?)')->execute([
    $user['_id'], 'withdrawal', -$amount, $newBalance, 'Withdrawal request', 'pending',
]);
jsonResponse(['success' => true, 'message' => 'Withdrawal request submitted', 'newBalance' => $newBalance]);
