<?php
require __DIR__ . '/../../../bootstrap.php';

$user = requireAuth();
$stmt = db()->prepare('SELECT id, type, amount, balance_after, description, status, created_at FROM wallet_transactions WHERE user_id = ? ORDER BY created_at DESC LIMIT 200');
$stmt->execute([$user['_id']]);
$list = [];
while ($t = $stmt->fetch()) {
    $list[] = [
        'id' => (string) $t['id'],
        'type' => $t['type'] ?? '',
        'amount' => (float) ($t['amount'] ?? 0),
        'balanceAfter' => (float) ($t['balance_after'] ?? 0),
        'description' => $t['description'] ?? '',
        'status' => $t['status'] ?? 'completed',
        'createdAt' => $t['created_at'] ? (new DateTime($t['created_at']))->format('c') : null,
    ];
}
jsonResponse(['success' => true, 'transactions' => $list]);
