<?php
require __DIR__ . '/../../../bootstrap.php';

$user = requireAuth();
$stmt = db()->prepare('SELECT wallet_balance FROM users WHERE id = ?');
$stmt->execute([$user['_id']]);
$u = $stmt->fetch();
$stmt = db()->query('SELECT min_withdraw_balance FROM settings WHERE id = 1');
$settings = $stmt->fetch();
$minBalance = (float) ($settings['min_withdraw_balance'] ?? 0);

jsonResponse([
    'success' => true,
    'balance' => (float) ($u['wallet_balance'] ?? 0),
    'minWithdrawBalance' => $minBalance,
    'canWithdraw' => ($user['kycStatus'] ?? '') === 'approved' && ($user['walletBalance'] ?? 0) >= $minBalance,
]);
