<?php
require __DIR__ . '/../../../bootstrap.php';

$user = getAuthUser();
if (!$user) {
    http_response_code(401);
    jsonResponse(['success' => false, 'message' => 'Unauthorized']);
    return;
}

$input = getJsonInput();
$transactionId = trim($input['transactionId'] ?? '');
$paymentScreenshot = $input['paymentScreenshot'] ?? '';

if (!$transactionId || !$paymentScreenshot) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'Transaction ID and payment screenshot required']);
    return;
}

$stmt = db()->prepare('UPDATE users SET registration_transaction_id = ?, registration_payment_screenshot = ?, registration_submitted_at = NOW() WHERE id = ?');
$stmt->execute([$transactionId, $paymentScreenshot, $user['_id']]);
jsonResponse(['success' => true, 'message' => 'Payment details submitted. Waiting for admin approval.']);
