<?php
require __DIR__ . '/../../../bootstrap.php';

$user = requireAuth();
$userId = $user['_id'];
$pdo = db();

function buildLevel(PDO $pdo, string $parentId, int $level): array {
    $stmt = $pdo->prepare('SELECT id, referral_id, name, number FROM users WHERE referred_by = ? AND status = ?');
    $stmt->execute([$parentId, 'approved']);
    $list = [];
    while ($u = $stmt->fetch()) {
        $id = (string) $u['id'];
        $node = [
            'id' => $id,
            'referralId' => $u['referral_id'] ?? '',
            'name' => $u['name'] ?? '',
            'number' => $level === 1 ? ($u['number'] ?? '') : null,
            'fullName' => $u['name'] ?? '',
            'level' => $level,
            'children' => $level < 6 ? buildLevel($pdo, $id, $level + 1) : [],
        ];
        $list[] = $node;
    }
    return $list;
}

$tree = buildLevel($pdo, $userId, 1);
jsonResponse(['success' => true, 'hierarchy' => $tree]);
