<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$input = getJsonInput();
$updates = [];
$params = [];
foreach (['qrCode' => 'qr_code', 'bankName' => 'bank_name', 'bankAccountNumber' => 'bank_account_number', 'bankIfsc' => 'bank_ifsc', 'accountHolderName' => 'account_holder_name'] as $k => $col) {
    if (isset($input[$k])) { $updates[] = "`$col` = ?"; $params[] = $input[$k]; }
}
if (isset($input['minWithdrawBalance'])) {
    $updates[] = 'min_withdraw_balance = ?';
    $params[] = (float) $input['minWithdrawBalance'];
}
if (empty($updates)) {
    jsonResponse(['success' => true]);
    return;
}
$sql = 'UPDATE settings SET ' . implode(', ', $updates) . ' WHERE id = 1';
db()->prepare($sql)->execute($params);
jsonResponse(['success' => true]);
