<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$input = getJsonInput();
$userId = $input['userId'] ?? '';
if (!$userId) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'userId required']);
    return;
}

$stmt = db()->prepare('UPDATE users SET status = ? WHERE id = ? AND status = ?');
$stmt->execute(['rejected', $userId, 'pending']);
if ($stmt->rowCount() === 0) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'User not found or not pending']);
    return;
}
jsonResponse(['success' => true]);
