<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$stmt = db()->prepare('
    SELECT u.*,
           r.name AS referrer_name,
           r.number AS referrer_number,
           r.email AS referrer_email,
           r.referral_id AS referrer_referral_id
    FROM users u
    LEFT JOIN users r ON r.id = u.referred_by
    WHERE u.status = ?
');
$stmt->execute(['pending']);
$list = [];
while ($u = $stmt->fetch()) {
    $list[] = [
        'id' => (string) $u['id'],
        'name' => $u['name'] ?? '',
        'email' => $u['email'] ?? '',
        'number' => $u['number'] ?? '',
        'dateOfBirth' => $u['date_of_birth'] ?? '',
        'referralId' => $u['referral_id'] ?? '',
        'referredBy' => $u['referred_by'] !== null ? (string) $u['referred_by'] : null,
        'referrerName' => $u['referrer_name'] ?? '',
        'referrerNumber' => $u['referrer_number'] ?? '',
        'referrerEmail' => $u['referrer_email'] ?? '',
        'referrerReferralId' => $u['referrer_referral_id'] ?? '',
        'registrationTransactionId' => $u['registration_transaction_id'] ?? '',
        'registrationPaymentScreenshot' => $u['registration_payment_screenshot'] ?? null,
        'registrationSubmittedAt' => $u['registration_submitted_at'] ? (new DateTime($u['registration_submitted_at']))->format('c') : null,
        'createdAt' => $u['created_at'] ? (new DateTime($u['created_at']))->format('c') : null,
    ];
}
jsonResponse(['success' => true, 'registrations' => $list]);
