<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$stmt = db()->prepare('SELECT * FROM users WHERE kyc_status = ? AND role = ?');
$stmt->execute(['pending', 'user']);
$list = [];
while ($u = $stmt->fetch()) {
    if (empty($u['kyc_aadhar_number'])) continue;
    $list[] = [
        'id' => (string) $u['id'],
        'name' => $u['name'] ?? '',
        'email' => $u['email'] ?? '',
        'number' => $u['number'] ?? '',
        'kycAadharNumber' => $u['kyc_aadhar_number'] ?? '',
        'kycPanNumber' => $u['kyc_pan_number'] ?? '',
        'kycBankAccountNumber' => $u['kyc_bank_account_number'] ?? '',
        'kycBankIfsc' => $u['kyc_bank_ifsc'] ?? '',
        'kycBankName' => $u['kyc_bank_name'] ?? '',
        'kycAccountHolderName' => $u['kyc_account_holder_name'] ?? '',
        'kycAadharImage' => $u['kyc_aadhar_image'] ?? null,
        'kycPanImage' => $u['kyc_pan_image'] ?? null,
        'kycSubmittedAt' => $u['kyc_submitted_at'] ? (new DateTime($u['kyc_submitted_at']))->format('c') : null,
    ];
}
jsonResponse(['success' => true, 'kycList' => $list]);
