<?php
require __DIR__ . '/../../../bootstrap.php';

requireAdmin();
$input = getJsonInput();
$userId = $input['userId'] ?? '';
if (!$userId) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'userId required']);
    return;
}

$pdo = db();
$stmt = $pdo->prepare('SELECT * FROM users WHERE id = ? AND status = ?');
$stmt->execute([$userId, 'pending']);
$user = $stmt->fetch();
if (!$user) {
    http_response_code(400);
    jsonResponse(['success' => false, 'message' => 'User not found or not pending']);
    return;
}

try {
    $pdo->prepare('UPDATE users SET status = ?, approved_at = NOW() WHERE id = ?')->execute(['approved', $userId]);
} catch (\PDOException $e) {
    if (strpos($e->getMessage(), 'approved_at') !== false) {
        $pdo->prepare('UPDATE users SET status = ? WHERE id = ?')->execute(['approved', $userId]);
    } else {
        throw $e;
    }
}

$pdo->prepare('INSERT INTO invoices (user_id, amount, type) VALUES (?, ?, ?)')->execute([$userId, 5000, 'purchase']);

$referredBy = $user['referred_by'];
$amounts = COMMISSION_AMOUNTS;
$level = 0;
while ($referredBy !== null && $level < 6) {
    $level++;
    $stmt = $pdo->prepare('SELECT id, wallet_balance, referred_by FROM users WHERE id = ? AND status = ?');
    $stmt->execute([$referredBy, 'approved']);
    $upline = $stmt->fetch();
    if (!$upline) break;
    $credit = $amounts[$level - 1];
    $newBal = (float) $upline['wallet_balance'] + $credit;
    $pdo->prepare('UPDATE users SET wallet_balance = ? WHERE id = ?')->execute([$newBal, $referredBy]);
    $pdo->prepare('INSERT INTO wallet_transactions (user_id, type, amount, balance_after, description, from_user_id) VALUES (?, ?, ?, ?, ?, ?)')->execute([
        (string) $referredBy, 'commission', $credit, $newBal, "Level $level commission", $userId,
    ]);
    $referredBy = $upline['referred_by'];
}

jsonResponse(['success' => true, 'message' => 'Registration approved and commissions distributed']);
