# MySQL setup

1. **Create database and tables**
   ```bash
   mysql -u root -p -e "CREATE DATABASE IF NOT EXISTS bonza;"
   mysql -u root -p bonza < schema.sql
   ```

2. **Configure `.env`** (copy from `.env.example` if needed)
   ```
   DB_HOST=127.0.0.1
   DB_NAME=bonza
   DB_USER=root
   DB_PASS=your_password
   JWT_SECRET=your-secret
   CORS_ORIGIN=*
   ```

3. **Create admin and founder users**
   ```bash
   cd backend
   php scripts/create-admin.php admin@bonza.com yourpassword
   ```
   This creates an admin and a founder user with referral code **FO0000** for the first MLM signup.

4. **Run backend**
   ```bash
   php -S localhost:8000 -t public
   ```
